

<?php $__env->startSection('title', $package->name); ?>

<?php $__env->startSection('content'); ?>
<div class="store-container">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 offset-lg-1">
                <div class="store-package-detail">
                    <div class="store-package-detail-image" style="background-image: url('<?php echo e(asset('storage/' . $package->image_path ?? 'images/store/default.jpg')); ?>')">
                        <?php if(Str::contains(strtolower($package->name), 'elite') && $package->type === 'vip'): ?>
                            <div class="store-package-badge">Elite</div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="store-package-detail-content">
                        <?php if($server): ?>
                        <div class="package-server-info">
                            <span class="server-badge">Available on: <?php echo e($server->name); ?></span>
                        </div>
                        <?php endif; ?>
                        
                        <div class="store-package-detail-header">
                            <h1><?php echo e($package->name); ?></h1>
                            <div class="price"><?php echo e(currency_symbol(config_value('store_currency', 'GBP'))); ?><?php echo e(number_format($package->price, 2)); ?></div>
                        </div>
                        
                        <div class="store-package-detail-description">
                            <p><?php echo e($package->description); ?></p>
                        </div>
                        
                        <div class="store-package-detail-features">
                            <h3>What's Included</h3>
                            <ul>
                                <?php $__currentLoopData = $package->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><span class="check-icon">✓</span><?php echo e($feature); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        
                        <div class="store-package-detail-actions">
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('store.payment.checkout', ['slug' => $package->slug, 'server_id' => $server ? $server->id : null])); ?>" class="btn-purchase">Purchase Now</a>
                            <?php else: ?>
                                <div class="login-required">
                                    <p>You need to be logged in to purchase this package.</p>
                                    <a href="<?php echo e(route('login.steam')); ?>" class="btn-login">Login</a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="store-package-detail-footer">
                        <a href="<?php echo e(route('store.index', $server ? ['server_id' => $server->id] : [])); ?>" class="btn-back">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
                            </svg>
                            Back to Store
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/store/show.blade.php ENDPATH**/ ?>